local COOLDOWN = 2000
local JUMP_HEIGHT = 180

function main(self)
	local claw = GetClaw()
	local cs = ClawStates

    if self.State == 0 then
		self.Flags.AlwaysActive, self.DrawFlags.NoDraw = true, true
		self.cooldown = 0
		self.jumpHeight = 0
		self.State = 1
	end

	if self.State == 1 then
		if (
			claw.State == cs.Stand
			or claw.State == cs.MoveLeft
			or claw.State == cs.MoveRight
			or claw.State == cs.Hit
			or claw.State == cs.Climb
			or claw.State == cs.OnEdge
		) then
			self.jumpHeight = 0
		elseif claw.State == cs.Jump then
			self.jumpHeight = PlayerData().JumpHeight
		end
		if claw.State == cs.Fall then
			self.State = 2
		end
	end

	if self.State == 2 then
		if PlayerData().FallHeight > self.jumpHeight and claw.State == cs.Fall and not GetInput"Jump" then
			self.State = 3
		end
		if claw.State ~= cs.Fall then
			self.State = 1
		end
	end

	if self.State == 3 then
		if GetInput"Jump" then
			self.cooldown = GetTime() + COOLDOWN
			ClawJump(JUMP_HEIGHT)
			CreateObject{X = claw.X, Y = claw.Y-18, Z = claw.Z-1, name="ArtifactPower:MercifulWingsEffect"}
			self.State = 4
		end
		if claw.State ~= cs.Fall then
			self.State = 1
		end
	end

	if self.State == 4 and GetTime() > self.cooldown then
		self.State = 1
	end
end
